import thumby
    
    
# THUMBWRITER CLASS --------------------------------------------- START

ARCADE_SQUAD = thumby.Sprite(5, 6,bytearray([14,31,17,14,0,18,31,31,16,0,18,25,31,22,0,17,21,27,26,0,6,4,31,31,0,23,23,21,9,0,14,31,21,13,0,25,29,5,3,0,30,31,21,31,0,22,23,25,14,0,30,31,9,30,0,31,31,21,10,0,14,31,17,10,0,31,31,17,14,0,14,31,21,19,0,31,31,5,1,0,14,31,17,29,0,31,31,4,31,0,17,31,31,17,0,9,17,31,15,0,31,31,8,23,0,31,31,16,16,0,31,6,3,31,0,31,31,1,30,0,14,31,17,14,0,31,31,9,6,0,14,31,17,46,0,31,31,9,22,0,22,23,29,25,0,1,31,31,1,0,15,31,16,31,0,15,31,16,15,0,31,24,12,31,0,27,31,6,27,0,23,23,20,31,0,25,29,23,19,0,24,24,0,0,0,24,56,0,0,0,2,17,21,6,0,23,23,0,0,0,0,27,27,0,0,17,8,5,19,0,0,11,7,0,0,11,0,11,7,0,12,30,22,12,0,10,31,10,31,0,4,4,4,0,0,10,10,10,0,0,0,6,9,17,34,17,9,6,0,0,49,32,46,49,63,45,32,32,47,63,45,38,32,41,63,46,42,36,37,63,57,59,32,32,63,40,40,42,54,63,49,32,42,50,63,38,34,58,60,63,33,32,42,32,63,41,40,38,49,63,33,32,54,33,63,32,32,42,53,63,49,32,46,53,63,32,32,46,49,63,49,32,42,44,63,32,32,58,62,63,49,32,46,34,63,32,32,59,32,63,46,32,32,46,63,54,46,32,48,63,32,32,55,40,63,32,32,47,47,63,32,57,60,32,63,32,32,62,33,63,49,32,46,49,63,32,32,54,57,63,49,32,46,17,63,32,32,54,41,63,41,40,34,38,63,62,32,32,62,63,48,32,47,32,63,48,32,47,48,63,32,39,51,32,63,36,32,57,36,63,40,40,43,32,63,38,34,40,44,63,39,39,63,63,63,39,7,63,63,63,61,46,42,57,63,40,40,63,63,63,63,36,36,63,63,46,55,58,44,63,56,52,63,52,63,52,63,52,56,63,51,33,41,51,63,53,32,53,32,63,59,59,59,63,63,53,53,53,63,63,63,57,54,46,29,46,54,57,63,63]),0,0)

class ThumbWriter:
    
    # CONSTRUCTOR ========================================= #
    # ----------------------------------------------------- #
    # text      The text to display                         #
    # x         The x-position where drawing begins         #
    # y         The y-position where drawing begins         #
    # color     0 for black, 1 for white                    #
    # delay     Measured in frames                          #
    # repeat    Re-writes the text upon completion if True  #
    # ===================================================== #
    def __init__(self, text="", x=0, y=0, color=0, delay=10, repeat=False):
        self.text = text
        self.x = x
        self.y = y
        self.color = color
        self.timer = -1
        self.next = 0
        self.delay = delay
        self.start = 0
        self.width = 0
        self.repeat = repeat
        
        self.sqnc = []
        q = 0
        for i in range(0,len(self.text)):
            ch = self.text[i:i+1]
            self.sqnc.append(int(ThumbWriter.cnvrt(ch,q,self.color)))
            if ch == "\"": q += 1
            
        if self.delay == 0:
            self.start = 0
            self.next = len(self.text)
       
    # DRAW ================================================ #
    # ----------------------------------------------------- #
    # Call this function to show the text!                  #
    # ===================================================== #
    def draw(self):
        #if thumby.actionPressed(): self.timer = self.delay
        offset = 0
        q = 0
        self.timer += 1
        if self.timer >= self.delay:
            self.next += 1
            if self.next < len(self.text):
                self.timer = 0
            elif self.next == len(self.text):
                self.timer = self.delay * -5
            else:
                if self.repeat and not thumby.actionPressed():
                    self.next = 0
                    self.start = 0
                    self.width = 0
                self.timer = self.delay * -2
                self.next -= 1
            if self.sqnc[self.next-1] == -1 or self.sqnc[self.next-1] == 48 or self.sqnc[self.next-1] == 98:
                self.timer = self.delay
        for i in range(self.start, self.next):
            if self.sqnc[i] == -1:
                offset += 2
                continue
            ARCADE_SQUAD.x = self.x + ( (i-self.start) * 5 ) - offset 
            ARCADE_SQUAD.y = self.y
            ARCADE_SQUAD.setFrame(self.sqnc[i])
            thumby.display.drawSprite(ARCADE_SQUAD)
            if (self.sqnc[i] >= 36 and self.sqnc[i] <= 39) or (self.sqnc[i] >= 86 and self.sqnc[i] <= 89):
                offset += 2
        self.width = ((self.next - self.start) * 5) - offset
        if self.x + self.width > 72: 
            self.start += 1
                
    # CNVRT =============================================== #
    # ----------------------------------------------------- #
    # This function converts a single character to a        #
    # specific frame within the Arcade Squad spritesheet.   #
    #                                                       #
    # ch        The character to investigate                #
    # q         How many double quotes have been spotted    #
    # color     0 for black, 1 for white                    #
    # ===================================================== #
    def cnvrt(ch, q=0, color=0):
        result = color * 50
        if ch == "0": result += 0
        elif ch == "1": result += 1
        elif ch == "2": result += 2
        elif ch == "3": result += 3
        elif ch == "4": result += 4
        elif ch == "5": result += 5
        elif ch == "6": result += 6
        elif ch == "7": result += 7
        elif ch == "8": result += 8
        elif ch == "9": result += 9
        elif ch == "A" or ch == "a": result += 10
        elif ch == "B" or ch == "b": result += 11
        elif ch == "C" or ch == "c": result += 12
        elif ch == "D" or ch == "d": result += 13
        elif ch == "E" or ch == "e": result += 14
        elif ch == "F" or ch == "f": result += 15
        elif ch == "G" or ch == "g": result += 16
        elif ch == "H" or ch == "h": result += 17
        elif ch == "I" or ch == "i": result += 18
        elif ch == "J" or ch == "j": result += 19
        elif ch == "K" or ch == "k": result += 20
        elif ch == "L" or ch == "l": result += 21
        elif ch == "M" or ch == "m": result += 22
        elif ch == "N" or ch == "n": result += 23
        elif ch == "O" or ch == "o": result += 24
        elif ch == "P" or ch == "p": result += 25
        elif ch == "Q" or ch == "q": result += 26
        elif ch == "R" or ch == "r": result += 27
        elif ch == "S" or ch == "s": result += 28
        elif ch == "T" or ch == "t": result += 29
        elif ch == "U" or ch == "u": result += 30
        elif ch == "V" or ch == "v": result += 31
        elif ch == "W" or ch == "w": result += 32
        elif ch == "X" or ch == "x": result += 33
        elif ch == "Y" or ch == "y": result += 34
        elif ch == "Z" or ch == "z": result += 35
        elif ch == ".": result += 36
        elif ch == ",": result += 37
        elif ch == "?": result += 38
        elif ch == "!": result += 39
        elif ch == ":": result += 40
        elif ch == "%": result += 41
        elif ch == "\"": result += 42 if q%2 == 0 else 43
        elif ch == "*": result += 44
        elif ch == "#": result += 45
        elif ch == "-": result += 46
        elif ch == "=": result += 47
        elif ch == "(": result += 48
        elif ch == ")": result += 49
        else: result = -1
        return result

# ---------------------------------------------------------------        
# =============================================================== END



# HELPFUL FUNCTIONS --------------------------------------------- START

# THIS FUNCTION RETURNS A SAVED ITEM FROM
# PERSISTENT STORAGE. IF THE ITEM DOESN'T
# EXIST, IT RETURNS A DEFAULT VALUE INSTEAD.
def ldSv(n,d):
    return int(thumby.saveData.getItem(n)) if thumby.saveData.hasItem(n) else d
    
# ---------------------------------------------------------------        
# =============================================================== END


    
# THE PROGRAM --------------------------------------------------- START
    
# SPECIFY A PERSISTENT DATA STORAGE FILE TO USE
thumby.saveData.setName("Tuner")

# LOAD ALL SPRITES
sprAUp = thumby.Sprite(10, 8, bytearray([60,126,195,193,237,195,126,189,66,60]), 61, 31)
sprADown = thumby.Sprite(10, 8, bytearray([0,0,60,126,195,193,237,195,126,60]), 61, 31)
sprBUp = thumby.Sprite(10, 8, bytearray([60,126,193,193,213,235,126,189,66,60]), 1, 31)
sprBDown = thumby.Sprite(10, 8, bytearray([0,0,60,126,193,193,213,235,126,60]), 1, 31)
sprArrow = thumby.Sprite(3, 7, bytearray([95,46,20,124,56,16]), 0, 16)

# PARALLEL ARRAYS FOR NOTES & THEIR NAMES
noteNames = ["G3", "G#3", "A3", "A#3", "B3", "C4", "C#4", "D4", "D#4", "E4", "F4", "F#4", "G4", "G#4", "A4", "A#4", "B4"]
noteFreqs = [196.0, 207.65, 220.0, 233.08, 246.94, 261.63, 277.18, 293.66, 311.13, 329.63, 349.23, 369.99, 392.0, 415.30, 440.0, 466.16, 493.88]

# MESSAGE THAT RUNS ACROSS THE TOP OF THE SCREEN
crawl = ThumbWriter("Micro Tuner for Thumby - Press Left or Right to Adjust the Note.  Press A to Toggle Sound.  Press B to Quit.",0,0,0,5,True)

# DEFAULT NOTE IS C4
noteId = ldSv("note", 5)

# APP RUNS AT 30 FRAMES PER SECOND
thumby.display.setFPS(30)

# SET THE DEFAULT FONT
thumby.display.setFont("/lib/font8x8.bin", 8, 8, 1)

# APP IS SILENT AT START
playing = False

# PLAY / QUIT LABEL FOR THE A BUTTON
toggle = ThumbWriter("Play", 40, 32, 0, 0)
quit = ThumbWriter("Quit", 13, 32, 0, 0)

# KEEP TRACK OF WHICH ACTION BUTTONS ARE DOWN
aDown = False
bDown = False

# CONTROL BLINKING LEFT AND RIGHT ARROWS
arrowTimer = 0
showArrows = True

# CONTROL THE MAIN LOOP
running = True

# THE MAIN LOOP!!
while running:
    
    # CLEAR THE BACKGROUND
    thumby.display.fill(0)
    
    # PLAY OR STOP THE AUDIO?
    if playing: 
        thumby.audio.play(round(noteFreqs[noteId]),7200000)
    else: 
        thumby.audio.stop()
            
    # HANDLE A-BUTTON PRESSES
    if thumby.buttonA.pressed():
        aDown = True
    else:
        if aDown:
            playing = not playing
            toggle = ThumbWriter("Stop", 40, 32, 0, 0) if playing else ThumbWriter("Play", 40, 32, 0, 0)
            aDown = False
            
    # HANDLE B-BUTTON PRESSES
    if thumby.buttonB.pressed():
        bDown = True
    else:
        if bDown:
            thumby.audio.stop()
            running = False
            
    # HANDLE LEFT D-PAD BUTTON
    if thumby.buttonL.justPressed() and noteId > 0: 
        noteId = noteId-1
        thumby.saveData.setItem("note", noteId)
        thumby.saveData.save()
        
    # HANDLE RIGHT D-PAD BUTTON
    if thumby.buttonR.justPressed() and noteId < len(noteFreqs)-1: 
        noteId = noteId+1
        thumby.saveData.setItem("note", noteId)
        thumby.saveData.save()
        
    # INCREASE THE BLINKING ARROW TIMER
    arrowTimer += 1
    
    # TOGGLE ARROW VISIBILITY?
    if arrowTimer >= 10:
        arrowTimer = 0
        showArrows = not showArrows
        
    # PRESSING LEFT OR RIGHT ON THE D-PAD
    # SHOWS THE ARROWS AND STARTS A LONG PAUSE
    if thumby.buttonL.pressed() or thumby.buttonR.pressed():
        arrowTimer = -20
        showArrows = True
    
    # DRAW THE A- AND B-BUTTON SPRITES
    thumby.display.drawSprite(sprADown) if thumby.buttonA.pressed() else thumby.display.drawSprite(sprAUp)
    thumby.display.drawSprite(sprBDown) if thumby.buttonB.pressed() else thumby.display.drawSprite(sprBUp)
    
    # DRAW THE LEFT AND RIGHT ARROW SPRITES
    if showArrows:
        
        # SET LOCATION AND PROPERTIES FOR THE LEFT ARROW
        sprArrow.mirrorX = 1
        sprArrow.x = 17
        sprArrow.setFrame(1 if thumby.buttonL.pressed() else 0)
        if noteId != 0: thumby.display.drawSprite(sprArrow)
        
        # SET LOCATION AND PROPERTIES FOR THE RIGHT ARROW
        sprArrow.mirrorX = 0
        sprArrow.x = 52
        sprArrow.setFrame(1 if thumby.buttonR.pressed() else 0)
        if noteId != len(noteFreqs)-1: thumby.display.drawSprite(sprArrow)

    # DRAW THE NAME OF THE NOTE IN THE MIDDLE OF THE SCREEN
    thumby.display.drawText(noteNames[noteId], int(36-(len(noteNames[noteId])/2)*8)-1, 16, 1)
    
    # DRAW PLAY / STOP LABEL
    toggle.draw()
    
    # DRAW QUIT LABEL
    quit.draw()
    
    # DRAW THE INSTRUCTIONS AT THE TOP OF THE SCREEN
    crawl.draw()
    
    # FLIP TO THE SCREEN
    thumby.display.update()
    
# ---------------------------------------------------------------        
# =============================================================== END
