# IMPORT REQUIRED LIBRARIES ========================================

import thumby
from collections import namedtuple

# ------------------------------------------------------------- END


# THE MUSIC =======================================================

Notes = namedtuple("Notes", ["G3", "A3", "A_SHARP3", "B3", "C4", "C_SHARP4", "D4", "D_SHARP4", "E4", "F4", "G4", "G_SHARP4"])
NOTES = Notes(               784,  880,  932,        988,  1047, 1109,       1175, 1245,       1318, 1397, 1568, 1661)

sheet = tuple([
    
        NOTES.C4, 150,
        NOTES.D4, 150,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 100,
        NOTES.D_SHARP4, 100,
        NOTES.D4, 100,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 300,
        NOTES.C4, 150,
        NOTES.D4, 150,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 100,
        NOTES.D_SHARP4, 100,
        NOTES.D4, 100,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 150,
        NOTES.F4, 150,
        NOTES.G4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.F4, 100,
        NOTES.G4, 100,
        NOTES.F4, 100,
        NOTES.D_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.F4, 150,
        NOTES.G4, 150,
        NOTES.G_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.G_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.G_SHARP4, 300,
        NOTES.G4, 100,
        NOTES.G_SHARP4, 100,
        NOTES.G4, 100,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.G_SHARP4, 300,
        NOTES.F4, 300,
        NOTES.G4, 300,
        NOTES.G_SHARP4, 300,
        NOTES.G4, 300,
        NOTES.G3, 150,
        NOTES.A3, 150,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.A3, 100,
        NOTES.A_SHARP3, 100,
        NOTES.A3, 100,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.A3, 300,
        NOTES.G3, 150,
        NOTES.A3, 150,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.A3, 100,
        NOTES.A_SHARP3, 100,
        NOTES.A3, 100,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.G3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 300,
        NOTES.A3, 300,
        NOTES.A_SHARP3, 150,
        NOTES.C4, 150,
        NOTES.D4, 300,
        NOTES.A_SHARP3, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.A_SHARP3, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.C4, 100,
        NOTES.D4, 100,
        NOTES.C4, 100,
        NOTES.A_SHARP3, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.A_SHARP3, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.A_SHARP3, 300,
        NOTES.C4, 150,
        NOTES.D4, 150,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 100,
        NOTES.D_SHARP4, 100,
        NOTES.D4, 100,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.C4, 300,
        NOTES.D4, 300,
        NOTES.D_SHARP4, 300,
        NOTES.D4, 300
    
    ])
    
# ------------------------------------------------------------- END



# MUSICROLL =======================================================

class MusicRoll:
    
    def __init__(self):
        self.tick = 0
        self.timer = 0
        self.next = 0
        pass
    
    def play(self):
        
        delay = 0.875
        if self.tick >= self.timer:
            thumby.audio.play(sheet[self.next], int(sheet[self.next+1]*delay))
            self.timer = int(sheet[self.next+1]* delay * (30.0/1000.0))
            self.next += 2
            if self.next >= len(sheet): self.next = 0
            self.tick = 0
        else:
            self.tick += 1

# ------------------------------------------------------------- END


# WRITER CLASS ====================================================

ARCADE_SQUAD = thumby.Sprite(5,6,bytearray([14,31,17,14,0,18,31,31,16,0,18,25,31,22,0,17,21,27,26,0,6,4,31,31,0,23,23,21,9,0,14,31,21,13,0,25,29,5,3,0,30,31,21,31,0,22,23,25,14,0,30,31,9,30,0,31,31,21,10,0,14,31,17,10,0,31,31,17,14,0,14,31,21,19,0,31,31,5,1,0,14,31,17,29,0,31,31,4,31,0,17,31,31,17,0,9,17,31,15,0,31,31,8,23,0,31,31,16,16,0,31,6,3,31,0,31,31,1,30,0,14,31,17,14,0,31,31,9,6,0,14,31,17,46,0,31,31,9,22,0,22,23,29,25,0,1,31,31,1,0,15,31,16,31,0,15,31,16,15,0,31,24,12,31,0,27,31,6,27,0,23,23,20,31,0,25,29,23,19,0,24,24,0,0,0,24,56,0,0,0,2,17,21,6,0,23,23,0,0,0,0,27,27,0,0,17,8,5,19,0,0,11,7,0,0,11,0,11,7,0,12,30,22,12,0,4,14,4,0,0,4,4,4,0,0,10,10,10,0,0,0,6,9,17,34,17,9,6,0,0,49,32,46,49,63,45,32,32,47,63,45,38,32,41,63,46,42,36,37,63,57,59,32,32,63,40,40,42,54,63,49,32,42,50,63,38,34,58,60,63,33,32,42,32,63,41,40,38,49,63,33,32,54,33,63,32,32,42,53,63,49,32,46,53,63,32,32,46,49,63,49,32,42,44,63,32,32,58,62,63,49,32,46,34,63,32,32,59,32,63,46,32,32,46,63,54,46,32,48,63,32,32,55,40,63,32,32,47,47,63,32,57,60,32,63,32,32,62,33,63,49,32,46,49,63,32,32,54,57,63,49,32,46,17,63,32,32,54,41,63,41,40,34,38,63,62,32,32,62,63,48,32,47,32,63,48,32,47,48,63,32,39,51,32,63,36,32,57,36,63,40,40,43,32,63,38,34,40,44,63,39,39,63,63,63,39,7,63,63,63,61,46,42,57,63,40,40,63,63,63,63,36,36,63,63,46,55,58,44,63,56,52,63,52,63,52,63,52,56,63,51,33,41,51,63,59,49,59,63,63,59,59,59,63,63,53,53,53,63,63,63,57,54,46,29,46,54,57,63,63]),0,0)

class Writer:
    
    # CONSTRUCTOR ========================================= #
    # ----------------------------------------------------- #
    # text      The text to display                         #
    # x         The x-position where drawing begins         #
    # y         The y-position where drawing begins         #
    # color     0 for black, 1 for white                    #
    # delay     Measured in frames                          #
    # repeat    Re-writes the text upon completion if True  #
    # ===================================================== #
    def __init__(self, text="", x=0, y=0, color=0, delay=10, repeat=False):
        self.text = text
        self.x = x
        self.y = y
        self.color = color
        self.timer = -1
        self.next = 0
        self.delay = delay
        self.start = 0
        self.width = 0
       
    # DRAW ================================================ #
    # ----------------------------------------------------- #
    # Call this function to show the text!                  #
    # ===================================================== #
    def draw(self):
        if thumby.actionPressed(): self.timer = self.delay
        offset = 0
        q = 0
        #if self.timer == -1: self.timer = 0
        self.timer += 1
        if self.timer >= self.delay:
            self.next += 1
            if self.next < len(self.text):
                self.timer = 0
            elif self.next == len(self.text):
                self.timer = self.delay * -5
            else:
                if not thumby.actionPressed():
                    self.next = 0
                    self.start = 0
                    self.width = 0
                self.timer = self.delay * -2
                self.next -= 1
            if self.text[self.next-1:self.next] == " ": self.timer = self.delay
        for i in range(self.start, self.next):
            ch = self.text[i:i+1]
            if ch == " ":
                offset += 2
                continue
            ARCADE_SQUAD.x = self.x + ( (i-self.start) * 5 ) - offset 
            ARCADE_SQUAD.y = self.y
            ARCADE_SQUAD.setFrame(int(Writer.cnvrt(ch,q,self.color)))
            thumby.display.drawSprite(ARCADE_SQUAD)
            if ch == "\"":
                q += 1
            elif ch == "," or ch == "." or ch == "!":
                offset += 2
        self.width = ((self.next - self.start) * 5) - offset
        if self.x + self.width > 72: 
            self.start += 1
                
    # CNVRT =============================================== #
    # ----------------------------------------------------- #
    # This function converts a single character to a        #
    # specific frame within the Arcade Squad spritesheet.   #
    #                                                       #
    # ch        The character to investigate                #
    # q         How many double quotes have been spotted    #
    # color     0 for black, 1 for white                    #
    # ===================================================== #
    def cnvrt(ch, q=0, color=0):
        result = color * 50
        if ch == "0": result += 0
        if ch == "1": result += 1
        if ch == "2": result += 2
        if ch == "3": result += 3
        if ch == "4": result += 4
        if ch == "5": result += 5
        if ch == "6": result += 6
        if ch == "7": result += 7
        if ch == "8": result += 8
        if ch == "9": result += 9
        if ch == "A" or ch == "a": result += 10
        if ch == "B" or ch == "b": result += 11
        if ch == "C" or ch == "c": result += 12
        if ch == "D" or ch == "d": result += 13
        if ch == "E" or ch == "e": result += 14
        if ch == "F" or ch == "f": result += 15
        if ch == "G" or ch == "g": result += 16
        if ch == "H" or ch == "h": result += 17
        if ch == "I" or ch == "i": result += 18
        if ch == "J" or ch == "j": result += 19
        if ch == "K" or ch == "k": result += 20
        if ch == "L" or ch == "l": result += 21
        if ch == "M" or ch == "m": result += 22
        if ch == "N" or ch == "n": result += 23
        if ch == "O" or ch == "o": result += 24
        if ch == "P" or ch == "p": result += 25
        if ch == "Q" or ch == "q": result += 26
        if ch == "R" or ch == "r": result += 27
        if ch == "S" or ch == "s": result += 28
        if ch == "T" or ch == "t": result += 29
        if ch == "U" or ch == "u": result += 30
        if ch == "V" or ch == "v": result += 31
        if ch == "W" or ch == "w": result += 32
        if ch == "X" or ch == "x": result += 33
        if ch == "Y" or ch == "y": result += 34
        if ch == "Z" or ch == "z": result += 35
        if ch == ".": result += 36
        if ch == ",": result += 37
        if ch == "?": result += 38
        if ch == "!": result += 39
        if ch == ":": result += 40
        if ch == "%": result += 41
        if ch == "\"": result += 42 if q%2 == 0 else 43
        if ch == "*": result += 44
        if ch == "+": result += 45
        if ch == "-": result += 46
        if ch == "=": result += 47
        if ch == "(": result += 48
        if ch == ")": result += 49
        return result
        
# ------------------------------------------------------------- END


# THE PROGRAM =====================================================

mr = MusicRoll()
bg = thumby.Sprite(72,36,bytearray([0,0,0,254,84,0,254,62,30,14,14,6,6,6,6,6,6,6,196,160,88,172,86,170,64,160,84,136,64,160,80,168,80,128,64,0,0,254,224,31,28,226,254,190,226,170,254,162,226,190,226,162,254,162,230,190,234,162,254,190,254,190,254,190,254,190,254,190,254,190,254,0,0,0,0,255,85,0,0,128,192,224,224,192,128,0,0,12,246,3,155,178,244,244,250,250,186,244,90,106,210,244,201,50,197,170,84,0,0,255,255,238,252,239,255,40,121,170,255,239,56,239,121,239,120,239,127,239,63,232,191,175,255,175,191,47,255,239,255,239,255,239,255,0,0,0,0,255,85,0,0,9,5,9,3,168,16,34,4,0,127,128,113,120,242,57,31,191,53,240,240,246,248,99,93,42,85,170,85,0,0,255,255,251,255,251,255,138,158,170,255,251,142,251,158,251,142,251,158,251,254,251,254,250,255,250,254,250,255,251,255,251,255,251,255,0,0,0,0,127,85,128,0,0,0,0,8,16,8,16,0,0,192,63,128,21,2,87,135,215,131,213,138,165,112,161,0,30,23,235,181,64,0,255,255,190,255,190,255,162,231,170,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,190,255,0,0,0,0,3,3,1,3,2,0,0,0,0,0,0,0,0,3,0,2,0,0,0,3,3,3,1,3,2,1,0,0,0,3,1,2,1,0,3,3,3,3,3,3,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0]),0,0)
thumby.display.setFPS(30)
msg = Writer("It\"s a sad thing that your adventures have ended here!!", 0, 35, 0, 5)
while True:
    mr.play()
    thumby.display.fill(0)
    thumby.display.drawSprite(bg)
    msg.draw()
    thumby.display.update()
    if thumby.buttonB.pressed(): break

# ------------------------------------------------------------- END