# IMPORT RELEVANT LIBRARIES ==========================
# ----------------------------------------------------
import thumby
import array

# ----------------------------------------------------


# DEFINE FUNCTIONS ===================================
# ----------------------------------------------------

# THIS FUNCTION RETURNS A LOADED SPRITE BASED ON
# A WIDTH, HEIGHT, X-POSITION, Y-POSITION, AND
# BYTE ARRAY.
def ldSpr(w,h,x,y,arr):
    return thumby.Sprite(w,h,arr,x,y)

# THIS FUNCTION RETURNS A SAVED ITEM FROM
# PERSISTENT STORAGE. IF THE ITEM DOESN'T
# EXIST, IT RETURNS A DEFAULT VALUE INSTEAD.
def ldSv(n,d):
    return int(thumby.saveData.getItem(n)) if thumby.saveData.hasItem(n) else d

# THIS FUNCTION RETURNS TRUE IF THE
# SPECIFIED YEAR IS A LEAP YEAR.
def isLeapYear(y):
    return y%4==0 and (y%100 != 0 or y%400 == 0)
    
# THIS FUNCTION RETURNS THE TOTAL NUMBER
# OF DAYS IN A GIVEN MONTH.
def daysInMonth(m,y):
    if m==4 or m==6 or m==9 or m==11:
        return 30
    elif m==2:
        return 29 if isLeapYear(y) else 28
    else:
        return 31

# THIS FUNCTION RETURNS THE NUMBER OF DAYS
# BETWEEN 10/21/2025 AND A SPECIFIED DATE
def elapsedDays(d2,m2,y2):
    
    # SET THE TARGET DATE
    m1 = 1
    d1 = 1
    y1 = 1900
    
    # INITIALIZE SOME COUNTERS
    days = 0
    
    # HOW MANY DAYS IN THE TARGET DATE?
    for i in range(y1, y2):
        days += 366 if isLeapYear(i) else 365
    for j in range(1, m2):
        days += daysInMonth(j,y2)
    days += (d2-1)
    
    # HOW MANY DAYS IN THE ORIGINAL DATE?
    for j in range(1, m1):
        days -= daysInMonth(j, y1)
    days -= (d1 - 1)
    
    # RETURN THE DIFFERENCE
    return days

# THIS FUNCTION RETURNS A VALUE THAT CORRESPONDS
# WITH A SPECIFIC PHASE OF THE MOON.
def getLunarDay(d,m,y):
    return(elapsedDays(d,m,y)%29.53058770576)

# THIS FUNCTION RETURNS THE PHASE OF THE MOON
# BASED ON A SPECIFIC DATE.
def getPhase(d,m,y):
    v = getLunarDay(d,m,y)
    #print(v)
    if   v <= 1:         return 0 # NEW MOON
    elif v <= 6.382647:  return 1 # WAXING CRESCENT
    elif v <= 8.382647:  return 2 # FIRST QUARTER
    elif v <= 13.765294: return 3 # WAXING GIBBOUS
    elif v <= 15.765294: return 4 # FULL MOON
    elif v <= 21.147941: return 5 # WANING GIBBOUS
    elif v <= 23.147941: return 6 # LAST QUARTER
    elif v <= 28.530588: return 7 # WANING CRESCENT
    else:                return 0 # NEW MOON
    
# THIS FUNCTION DRAWS A GIVEN SPRITE AT THE
# POSITION SPECIFIED, USING THE CORRECT FRAME
def drwSpr(spr, x, y, f):
    spr.x = x
    spr.y = y
    spr.setFrame(f)
    thumby.display.drawSprite(spr)
    pass
    
# THIS FUNCTION CONTROLS THE "SET DATE" SCENE
def setDate():
    
    # WHICH GLOBAL VARIABLES ARE WE POTENTIALLY CHANGING?
    global state
    global timer
    global blink
    global sprSelector
    global positionId
    global aDown
    global day
    global month
    global year
    
    # DRAW THE BACKGROUND IMAGE
    thumby.display.drawSprite(sprSetDateBg)
    
    # CONTROL WHETHER THE SELECTION
    # MARKER IS VISIBLE OR NOT
    timer+=1
    if timer >= 20:
        timer = 0
        blink = not blink
    
    # IF THE SELECTION MARKER IS
    # VISIBLE, THEN DRAW IT!
    if blink:
        sprSelector.mirrorY = 0 # UNFLIPPED ABOVE, AND...
        drwSpr(sprSelector, positions[positionId], 2, 0)
        sprSelector.mirrorY = 1 # ...FLIPPED BELOW!
        drwSpr(sprSelector, positions[positionId], 24, 0)
        
    # CONTROL THE POSITION OF THE SELECTOR
    # BASED ON D-PAD BUTTON PRESSES
    if thumby.buttonR.justPressed() and positionId < 2:
        thumby.audio.play(4500, 50)
        positionId += 1
    elif thumby.buttonL.justPressed() and positionId > 0:
        thumby.audio.play(4500, 50)
        positionId -= 1
        
    # PRESSING THE UP OR DOWN BUTTONS ON
    # THE D-PAD ADJUSTS THE DATE
    if thumby.buttonU.justPressed():
        thumby.audio.play(4500, 50)
        if positionId == 0: #MONTH
            month = month + 1 if month < 12 else 1
        if positionId == 1: #DAY
            day = day + 1 if day < daysInMonth(month,year) else 1
        if positionId == 2: #YEAR
            year = year + 1
        day = daysInMonth(month,year) if day > daysInMonth(month,year) else day
    elif thumby.buttonD.justPressed():
        thumby.audio.play(4500, 50)
        if positionId == 0: #MONTH
            month = month - 1 if month > 1 else 12
        if positionId == 1: #DAY
            day = day - 1 if day > 1 else daysInMonth(month,year)
        if positionId == 2: #YEAR
            year = year - 1 if year > 1900 else 1900
        day = daysInMonth(month,year) if day > daysInMonth(month,year) else day
        
    # DRAW THE FULL DATE USING 
    # THE "BIG NUMBER" SPRITES
    drwSpr(sprBigNums, 5,  9, int(month / 10))    # DISPLAY MONTH
    drwSpr(sprBigNums, 11, 9, int(month % 10))
    drwSpr(sprBigNums, 24, 9, int(day / 10))     # DISPLAY DAY
    drwSpr(sprBigNums, 30, 9, int(day % 10))
    drwSpr(sprBigNums, 43, 9, int(year / 1000))  # DISPLAY YEAR
    drwSpr(sprBigNums, 49, 9, int(year / 100))
    drwSpr(sprBigNums, 55, 9, int(year / 10))
    drwSpr(sprBigNums, 61, 9, int(year % 10))
    
    # HANDLE A-BUTTON PRESSES
    if thumby.buttonA.pressed():
        
        # LOW BEEP IF THE A-BUTTON WAS PREVIOUSLY UP
        if not aDown: thumby.audio.play(6000, 50)
            
        # RECORD THAT THE A-BUTTON IS NOW DOWN
        aDown = True
        
    else:
        
        # WAS THE A-BUTTON PREVIOUSLY DOWN?
        if aDown:
            
            # HIGH BEEP
            thumby.audio.play(8000, 50)
            
            # SAVE THE DATE!
            thumby.saveData.setItem("month", month)
            thumby.saveData.setItem("day", day)
            thumby.saveData.setItem("year", year)
            thumby.saveData.save()
            
            # CALCULATE THE CORRECT PHASE
            # OF THE MOON AND PREPARE THE
            # MATCHING ICON / NAME SPRITES
            sprMoons.setFrame(getPhase(day,month,year))
            sprNames.setFrame(sprMoons.getFrame())
            
            # GO TO THE NEXT SCENE ("SHOW MOON PHASE")
            state = 1
          
        # RECORD THAT THE A-BUTTON IS NOW UP  
        aDown = False
    
    # DRAW THE A-BUTTON SPRITE
    thumby.display.drawSprite(sprADown if thumby.buttonA.pressed() else sprAUp)
    
# THIS FUNCTION CONTROLS THE "SHOW MOON PHASE" SCENE
def showPhase():
    
    # WHICH GLOBAL VARIABLES ARE WE POTENTIALLY CHANGING?
    global running
    global state
    global aDown
    global bDown
    global positionId
    
    # DRAW THE BACKGROUND IMAGE
    thumby.display.drawSprite(sprPhaseBg)
    
    # HANDLE A-BUTTON CONTROLS
    if thumby.buttonA.pressed():
        if not aDown:
            thumby.audio.play(6000, 50)
        aDown = True
    else:
        if aDown:
            thumby.audio.play(8000, 50)
            running = False     # QUIT!
        aDown = False
        
    # HANDLE B-BUTTON CONTROLS
    if thumby.buttonB.pressed():
        if not bDown:
            thumby.audio.play(6000, 50)
        bDown = True
    else:
        if bDown:
            thumby.audio.play(8000, 50)
            positionId = 0      # RESET THE SELECTOR POSITION
            state = 0           # GO BACK TO "SET DATE" SCENE
        bDown = False
    
    # DRAW THE ABBREVIATED DATE USING 
    # THE "SMALL NUMBER" SPRITES
    drwSpr(sprSmallNums,37,2,int(month / 10)) # DISPLAY MONTH
    drwSpr(sprSmallNums,42,2,int(month % 10))
    drwSpr(sprSmallNums,49,2,int(day / 10)) # DISPLAY DAY
    drwSpr(sprSmallNums,54,2,int(day % 10))
    drwSpr(sprSmallNums,61,2,int(year / 10)) # DISPLAY YEAR
    drwSpr(sprSmallNums,66,2,int(year % 10))
        
    # DRAW THE A- AND B-BUTTON SPRITES
    thumby.display.drawSprite(sprADown if thumby.buttonA.pressed() else sprAUp)
    thumby.display.drawSprite(sprBDown if thumby.buttonB.pressed() else sprBUp)
    
    # DRAW THE MOON ICON AND PHASE NAME
    thumby.display.drawSprite(sprMoons)
    thumby.display.drawSprite(sprNames)
        
# ----------------------------------------------------


# PROGRAM START ======================================
# ----------------------------------------------------

# THIS APP RUNS AT 30 FPS
thumby.display.setFPS(30)

# SPECIFY A PERSISTENT DATA STORAGE FILE TO USE
thumby.saveData.setName("MoonPhase")

# RUNNING CONTROLS THE APP'S MAIN LOOP (BELOW)
running = True

# WHICH STATE ARE WE IN? 0 SETS THE DATE.
state = 0

# PRELOAD ALL REQUIRED SPRITES
sprSetDateBg    = ldSpr(72, 40, 0,  0,  bytearray([0,0,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,0,0,0,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,0,0,0,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,85,170,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,85,170,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,85,170,0,0,0,0,0,127,64,64,64,64,64,64,64,64,64,64,64,64,64,127,85,42,0,0,127,64,64,64,64,64,64,64,64,64,64,64,64,64,127,85,42,0,0,127,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,127,85,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,39,61,25,0,30,63,41,35,0,1,63,63,1,0,0,0,63,63,33,30,0,62,63,9,62,0,1,63,63,1,0,30,63,41,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0]))
sprPhaseBg      = ldSpr(72, 40, 0,  0,  bytearray([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,31,21,10,0,30,31,9,30,0,14,31,17,10,0,31,31,8,23,0,0,0,0,0,0,0,0,14,31,17,46,0,15,31,16,31,0,17,31,31,17,0,1,31,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0]))
sprSelector     = ldSpr(8,  4,  7,  3,  bytearray([4,6,7,6,4,1,2,4]))
sprAUp          = ldSpr(10, 8,  61, 31, bytearray([60,126,195,193,237,195,126,189,66,60]))
sprADown        = ldSpr(10, 8,  61, 31, bytearray([0,0,60,126,195,193,237,195,126,60]))
sprBUp          = ldSpr(10, 8,  1,  31, bytearray([60,126,193,193,213,235,126,189,66,60]))
sprBDown        = ldSpr(10, 8,  1,  31, bytearray([0,0,60,126,193,193,213,235,126,60]))
sprMoons        = ldSpr(27, 27, 4,  2,  bytearray([0,0,192,32,16,8,4,4,2,2,1,1,1,1,1,1,1,2,2,4,4,8,16,32,192,0,0,252,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,252,1,6,24,32,64,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,64,32,24,6,1,0,0,0,0,0,0,1,1,2,2,4,4,4,4,4,4,4,2,2,1,1,0,0,0,0,0,0,0,0,192,32,16,8,4,4,2,2,1,1,1,1,1,1,1,2,6,12,60,248,240,96,192,0,0,252,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,93,170,255,252,1,6,24,32,64,128,0,0,0,0,0,0,0,0,0,0,0,0,128,192,240,252,127,53,27,7,1,0,0,0,0,0,0,1,1,2,2,4,4,4,4,4,4,6,3,3,1,1,0,0,0,0,0,0,0,0,192,32,16,8,4,4,2,2,1,1,1,1,255,125,191,94,190,252,188,248,240,96,192,0,0,252,3,0,0,0,0,0,0,0,0,0,0,0,0,1,245,254,255,250,245,235,247,191,93,170,255,252,1,6,24,32,64,128,0,0,0,0,0,0,0,0,252,255,255,255,251,253,251,255,127,53,27,7,1,0,0,0,0,0,0,1,1,2,2,4,4,4,4,7,7,7,3,3,1,1,0,0,0,0,0,0,0,0,192,32,16,8,132,68,162,82,169,85,173,117,255,125,191,94,190,252,188,248,240,96,192,0,0,252,3,0,0,32,214,170,223,255,221,174,221,174,119,239,245,254,255,250,245,235,247,191,93,170,255,252,1,6,24,32,64,131,11,63,123,247,234,213,235,255,255,255,255,255,251,253,251,255,127,53,27,7,1,0,0,0,0,0,0,1,1,2,2,4,5,5,5,7,7,7,3,3,1,1,0,0,0,0,0,0,0,0,192,96,176,120,172,124,170,86,173,87,173,119,255,125,191,94,190,252,188,248,240,96,192,0,0,252,215,170,117,239,215,170,223,255,221,174,221,174,119,239,245,254,255,250,245,235,247,191,93,170,255,252,1,7,31,61,111,247,171,127,251,247,234,213,235,255,255,255,255,255,251,253,251,255,127,53,27,7,1,0,0,0,0,0,0,1,1,3,3,7,7,7,7,7,7,7,3,3,1,1,0,0,0,0,0,0,0,0,192,96,176,120,172,124,170,86,173,87,173,119,253,125,189,90,178,228,132,8,16,32,192,0,0,252,215,170,117,239,215,170,223,255,221,174,221,174,119,239,245,254,255,250,245,235,247,184,0,0,3,252,1,7,31,61,111,247,171,127,251,247,234,213,235,255,255,255,255,255,123,61,59,135,64,32,24,6,1,0,0,0,0,0,0,1,1,3,3,7,7,7,3,3,3,5,2,2,1,1,0,0,0,0,0,0,0,0,192,96,176,120,172,124,170,86,173,87,173,1,1,1,1,2,2,4,4,8,16,32,192,0,0,252,215,170,117,239,215,170,223,255,221,174,221,0,0,0,0,0,0,0,0,0,0,0,0,0,3,252,1,7,31,61,111,247,171,127,251,247,234,213,232,0,0,0,0,0,0,0,0,128,64,32,24,6,1,0,0,0,0,0,0,1,1,3,3,7,7,7,4,4,4,4,2,2,1,1,0,0,0,0,0,0,0,0,192,96,176,120,44,12,10,6,5,3,1,1,1,1,1,2,2,4,4,8,16,32,192,0,0,252,215,170,117,239,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,252,1,7,31,61,111,244,168,64,0,0,0,0,0,0,0,0,0,0,0,0,0,128,64,32,24,6,1,0,0,0,0,0,0,1,1,3,2,4,4,0,0,0,0,4,2,2,1,1,0,0,0,0,0,0]))
sprNames        = ldSpr(37, 11, 35, 13, bytearray([0,0,0,0,0,0,0,0,64,128,16,157,6,24,31,128,72,218,151,21,1,128,77,223,144,14,88,143,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,3,6,3,6,0,3,7,4,2,1,0,3,7,4,2,1,4,7,1,6,7,0,0,0,0,0,0,0,0,141,223,80,78,24,79,192,80,157,15,133,222,64,80,155,198,76,211,0,144,217,95,83,129,208,93,6,88,159,0,204,30,83,213,205,64,3,7,4,4,0,4,7,3,6,5,2,6,5,5,2,4,7,6,0,3,7,4,4,2,6,5,5,0,7,1,6,7,0,4,6,7,0,0,128,64,192,128,16,93,207,5,69,208,25,95,211,65,144,29,15,89,214,64,136,18,95,89,195,64,81,157,223,65,65,0,64,192,64,128,3,7,4,2,5,0,3,7,4,7,3,4,7,3,1,7,0,4,7,3,6,5,0,4,7,7,0,2,6,5,5,0,4,7,3,6,5,0,141,223,80,78,24,79,192,208,93,15,69,222,64,144,27,70,204,83,128,16,25,159,83,193,144,29,70,216,31,64,204,30,147,213,77,192,3,7,4,5,3,4,6,7,4,0,4,7,3,5,2,4,7,3,5,2,0,3,7,4,2,1,0,3,7,4,7,1,2,4,7,6,0,0,0,0,0,0,0,0,16,93,143,5,133,0,13,31,144,93,207,128,16,29,151,81,208,128,16,93,151,17,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,3,6,3,6,0,3,7,4,2,1,0,3,7,4,2,1,4,7,1,6,7,0,0,0,0,0,0,0,0,141,223,80,78,24,79,192,208,93,15,69,222,64,144,29,70,216,95,128,16,25,159,83,193,144,29,70,216,31,64,204,30,147,213,77,192,3,7,4,5,3,4,6,7,4,0,4,7,3,5,2,4,7,3,5,2,0,3,7,4,2,1,0,3,7,4,7,1,2,4,7,6,0,0,128,64,192,128,0,64,208,29,87,209,16,64,208,93,143,5,30,64,200,82,159,25,67,64,209,93,95,129,193,64,64,0,64,192,64,128,3,7,4,2,5,0,3,7,4,7,3,4,7,3,1,7,0,4,7,3,6,5,0,4,7,7,0,2,6,5,5,0,4,7,3,6,5,0,141,223,80,78,24,79,192,80,157,15,133,222,64,80,157,198,88,223,0,144,217,95,83,129,208,93,6,88,159,0,204,30,83,213,205,64,3,7,4,4,0,4,7,3,6,5,2,6,5,5,2,4,7,6,0,3,7,4,4,2,6,5,5,0,7,1,6,7,0,4,6,7,0]))
sprSmallNums    = ldSpr(4,  5,  0,  2,  bytearray([14,31,17,14,18,31,31,16,18,25,31,22,17,21,27,26,6,4,31,31,23,23,21,9,14,31,21,13,25,29,5,3,30,31,21,31,22,23,25,14]))
sprBigNums      = ldSpr(5,  12, 5,  9,  bytearray([248,254,15,3,254,7,15,12,14,3,12,6,255,255,0,8,14,15,15,8,12,134,199,127,30,14,15,15,8,12,12,6,67,103,190,6,12,12,14,7,120,102,227,253,79,8,14,15,15,8,124,126,38,97,195,6,12,12,14,7,240,124,46,99,193,7,14,12,14,7,14,7,227,255,15,8,14,15,15,0,56,254,79,67,190,7,15,12,14,3,62,103,67,231,254,8,12,7,3,0]))

# CONTROL RATE OF BLINKING OBJECTS
timer = 0
blink = True

# ARRAY OF SELECTOR POSITIONS
# AND THEIR STARTING INDEX
positions = array.array('i',[7,26,51])
positionId = 0

# STATE OF THE BUTTONS
aDown = False
bDown = False

# LOAD DATE INFORMATION FROM STORAGE
# OR USE DEFAULT DATE OF 12/01/2025.
month   = ldSv("month", 12)
day     = ldSv("day",   1)
year    = ldSv("year",  2025)

# START THE MAIN LOOP
while running:
    if state == 0:
        setDate()
    else:
        showPhase()
    thumby.display.update()

# ---------------------------------------------------- END