import thumby


# WRITER CLASS ====================================================

ARCADE_SQUAD = thumby.Sprite(5,6,bytearray([14,31,17,14,0,18,31,31,16,0,18,25,31,22,0,17,21,27,26,0,6,4,31,31,0,23,23,21,9,0,14,31,21,13,0,25,29,5,3,0,30,31,21,31,0,22,23,25,14,0,30,31,9,30,0,31,31,21,10,0,14,31,17,10,0,31,31,17,14,0,14,31,21,19,0,31,31,5,1,0,14,31,17,29,0,31,31,4,31,0,17,31,31,17,0,9,17,31,15,0,31,31,8,23,0,31,31,16,16,0,31,6,3,31,0,31,31,1,30,0,14,31,17,14,0,31,31,9,6,0,14,31,17,46,0,31,31,9,22,0,22,23,29,25,0,1,31,31,1,0,15,31,16,31,0,15,31,16,15,0,31,24,12,31,0,27,31,6,27,0,23,23,20,31,0,25,29,23,19,0,24,24,0,0,0,24,56,0,0,0,2,17,21,6,0,23,23,0,0,0,0,27,27,0,0,17,8,5,19,0,0,11,7,0,0,11,0,11,7,0,12,30,22,12,0,4,14,4,0,0,4,4,4,0,0,10,10,10,0,0,0,6,9,17,34,17,9,6,0,0,49,32,46,49,63,45,32,32,47,63,45,38,32,41,63,46,42,36,37,63,57,59,32,32,63,40,40,42,54,63,49,32,42,50,63,38,34,58,60,63,33,32,42,32,63,41,40,38,49,63,33,32,54,33,63,32,32,42,53,63,49,32,46,53,63,32,32,46,49,63,49,32,42,44,63,32,32,58,62,63,49,32,46,34,63,32,32,59,32,63,46,32,32,46,63,54,46,32,48,63,32,32,55,40,63,32,32,47,47,63,32,57,60,32,63,32,32,62,33,63,49,32,46,49,63,32,32,54,57,63,49,32,46,17,63,32,32,54,41,63,41,40,34,38,63,62,32,32,62,63,48,32,47,32,63,48,32,47,48,63,32,39,51,32,63,36,32,57,36,63,40,40,43,32,63,38,34,40,44,63,39,39,63,63,63,39,7,63,63,63,61,46,42,57,63,40,40,63,63,63,63,36,36,63,63,46,55,58,44,63,56,52,63,52,63,52,63,52,56,63,51,33,41,51,63,59,49,59,63,63,59,59,59,63,63,53,53,53,63,63,63,57,54,46,29,46,54,57,63,63]),0,0)

class ThumbWriter:
    
    # CONSTRUCTOR ========================================= #
    # ----------------------------------------------------- #
    # text      The text to display                         #
    # x         The x-position where drawing begins         #
    # y         The y-position where drawing begins         #
    # color     0 for black, 1 for white                    #
    # delay     Measured in frames                          #
    # repeat    Re-writes the text upon completion if True  #
    # ===================================================== #
    def __init__(self, text="", x=0, y=0, color=0, delay=10, repeat=False):
        self.text = text
        self.x = x
        self.y = y
        self.color = color
        self.timer = -1
        self.next = 0
        self.delay = delay
        self.start = 0
        self.width = 0
        self.repeat = repeat
        
        self.sqnc = []
        q = 0
        for i in range(0,len(self.text)):
            ch = self.text[i:i+1]
            self.sqnc.append(int(ThumbWriter.cnvrt(ch,q,self.color)))
            if ch == "\"": q += 1
            
        if self.delay == 0:
            self.start = 0
            self.next = len(self.text)
       
    # DRAW ================================================ #
    # ----------------------------------------------------- #
    # Call this function to show the text!                  #
    # ===================================================== #
    def draw(self):
        #if thumby.actionPressed(): self.timer = self.delay
        offset = 0
        q = 0
        self.timer += 1
        if self.timer >= self.delay:
            self.next += 1
            if self.next < len(self.text):
                self.timer = 0
            elif self.next == len(self.text):
                self.timer = self.delay * -5
            else:
                if self.repeat and not thumby.actionPressed():
                    self.next = 0
                    self.start = 0
                    self.width = 0
                self.timer = self.delay * -2
                self.next -= 1
            if self.sqnc[self.next-1] == -1 or self.sqnc[self.next-1] == 48 or self.sqnc[self.next-1] == 98:
                self.timer = self.delay
        for i in range(self.start, self.next):
            if self.sqnc[i] == -1:
                offset += 2
                continue
            ARCADE_SQUAD.x = self.x + ( (i-self.start) * 5 ) - offset 
            ARCADE_SQUAD.y = self.y
            ARCADE_SQUAD.setFrame(self.sqnc[i])
            thumby.display.drawSprite(ARCADE_SQUAD)
            if (self.sqnc[i] >= 36 and self.sqnc[i] <= 39) or (self.sqnc[i] >= 86 and self.sqnc[i] <= 89):
                offset += 2
        self.width = ((self.next - self.start) * 5) - offset
        if self.x + self.width > 72: 
            self.start += 1
                
    # CNVRT =============================================== #
    # ----------------------------------------------------- #
    # This function converts a single character to a        #
    # specific frame within the Arcade Squad spritesheet.   #
    #                                                       #
    # ch        The character to investigate                #
    # q         How many double quotes have been spotted    #
    # color     0 for black, 1 for white                    #
    # ===================================================== #
    def cnvrt(ch, q=0, color=0):
        result = color * 50
        if ch == "0": result += 0
        elif ch == "1": result += 1
        elif ch == "2": result += 2
        elif ch == "3": result += 3
        elif ch == "4": result += 4
        elif ch == "5": result += 5
        elif ch == "6": result += 6
        elif ch == "7": result += 7
        elif ch == "8": result += 8
        elif ch == "9": result += 9
        elif ch == "A" or ch == "a": result += 10
        elif ch == "B" or ch == "b": result += 11
        elif ch == "C" or ch == "c": result += 12
        elif ch == "D" or ch == "d": result += 13
        elif ch == "E" or ch == "e": result += 14
        elif ch == "F" or ch == "f": result += 15
        elif ch == "G" or ch == "g": result += 16
        elif ch == "H" or ch == "h": result += 17
        elif ch == "I" or ch == "i": result += 18
        elif ch == "J" or ch == "j": result += 19
        elif ch == "K" or ch == "k": result += 20
        elif ch == "L" or ch == "l": result += 21
        elif ch == "M" or ch == "m": result += 22
        elif ch == "N" or ch == "n": result += 23
        elif ch == "O" or ch == "o": result += 24
        elif ch == "P" or ch == "p": result += 25
        elif ch == "Q" or ch == "q": result += 26
        elif ch == "R" or ch == "r": result += 27
        elif ch == "S" or ch == "s": result += 28
        elif ch == "T" or ch == "t": result += 29
        elif ch == "U" or ch == "u": result += 30
        elif ch == "V" or ch == "v": result += 31
        elif ch == "W" or ch == "w": result += 32
        elif ch == "X" or ch == "x": result += 33
        elif ch == "Y" or ch == "y": result += 34
        elif ch == "Z" or ch == "z": result += 35
        elif ch == ".": result += 36
        elif ch == ",": result += 37
        elif ch == "?": result += 38
        elif ch == "!": result += 39
        elif ch == ":": result += 40
        elif ch == "%": result += 41
        elif ch == "\"": result += 42 if q%2 == 0 else 43
        elif ch == "*": result += 44
        elif ch == "+": result += 45
        elif ch == "-": result += 46
        elif ch == "=": result += 47
        elif ch == "(": result += 48
        elif ch == ")": result += 49
        else: result = -1
        return result

# ---------------------------------------------------------------        
# =============================================================== END



# HELPFUL FUNCTIONS ===============================================

# CONVERT A BYTE (AS STRING) INTO HEX
def byteToHex(byte):
    h = ["0",   "1",    "2",    "3",    "4",    "5",    "6",    "7",    "8",    "9",    "A",    "B",    "C",    "D",    "E",    "F"]
    b = ["0000","0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"]
    h1=0;
    h2=0;
    for i in range(0,16):
        if b[i]==byte[0:4]: h1 = i
        if b[i]==byte[4:8]: h2 = i
    return h[h1]+h[h2]
    
    
# CONVERT A TWO-DIGIT HEX (AS STRING) INTO A BYTE
def hexToByte(hx):
    h = ["0",   "1",    "2",    "3",    "4",    "5",    "6",    "7",    "8",    "9",    "A",    "B",    "C",    "D",    "E",    "F"]
    b = ["0000","0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"]
    h1=0;
    h2=0;
    for i in range(0,16):
        if h[i]==hx[0:1]: h1 = i
        if h[i]==hx[1:2]: h2 = i
    return b[h1]+b[h2]
    
    
# CONVERT A BYTE (AS STRING) INTO DECIMAL
def byteToDec(byte):
    s = list(byte)
    d = 128 * int(s[0]) + 64 * int(s[1]) + 32 * int(s[2]) + 16 * int(s[3]) + 8 * int(s[4]) + 4 * int(s[5]) +2 * int(s[6]) + 1 * int(s[7])
    if d <= 9:
        d = "00"+str(d)
    elif d <= 99:
        d = "0"+str(d)
    else:
        d = str(d)
    return d
    
    
# CONVERT A THREE DIGIT DECIMAL (AS STRING) INTO A BYTE
def decToByte(dec):
    b = [128,64,32,16,8,4,2,1]
    s = ["0","0","0","0","0","0","0","0"]
    for i in range(0,8):
        if dec >= b[i]:
            dec -= b[i]
            s[i] = "1"
    return "".join(s)
    
    
# TOGGLES A BINARY DIGIT
def adjustBinDigit():
    
    # GLOBAL OBJECTS WE NEED TO CHANGE?
    global binary
    global decimal
    global hexadecimal
    
    # BEEP!
    thumby.audio.play(4500, 50)
    
    # ADJUST DIGIT IN CURRENT COLUMN
    s = list(binary.text)
    s[col] = "1" if s[col] == "0" else "0"
    
    # APPLY NEW BINARY VALUE
    binary = ThumbWriter("".join(s),27,0,0,0,False)
    # CONVERT TO DECIMAL
    decimal = ThumbWriter(byteToDec(binary.text),52,11,0,0,False)
    # CONVERT TO HEX
    hexadecimal = ThumbWriter(byteToHex(binary.text),57,22,0,0,False)
    
    
# ADJUSTS A DECIMAL DIGIT UP OR DOWN
def adjustDecDigit():
    
    # GLOBAL OBJECTS WE NEED TO CHANGE?
    global binary
    global decimal
    global hexadecimal
    
    # BEEP!
    thumby.audio.play(4500, 50)
    
    # LISTIFY THE DECIMAL STRING
    s = list(decimal.text)
    
    # ADJUST UP?
    if thumby.buttonU.pressed():
        if col == 1:
            if int(s[0]) < 2: 
                s[col] = str(int(s[col])+1) if int(s[col]) < 9 else "0"
            else:
                s[col] = str(int(s[col])+1) if int(s[col]) < 5 else "0"
        elif col == 2:
            if int(s[0]) == 2 and int(s[1]) == 5: 
                s[col] = str(int(s[col])+1) if int(s[col]) < 5 else "0"
            else:
                s[col] = str(int(s[col])+1) if int(s[col]) < 9 else "0"
        elif col == 0:
            s[col] = str(int(s[col])+1) if int(s[col]) < 2 else "0"
            
    # ADJUST DOWN?
    elif thumby.buttonD.pressed():
        if col == 1:
            if int(s[0]) < 2: 
                s[col] = str(int(s[col])-1) if int(s[col]) > 0 else "9"
            else:
                s[col] = str(int(s[col])-1) if int(s[col]) > 0 else "5"
        elif col == 2:
            if int(s[0]) == 2 and int(s[1]) == 5: 
                s[col] = str(int(s[col])-1) if int(s[col]) > 0 else "5"
            else:
                s[col] = str(int(s[col])-1) if int(s[col]) > 0 else "9"
        elif col == 0:
            s[col] = str(int(s[col])-1) if int(s[col]) > 0 else "2"
            
    # CAN'T GO ABOVE 255!
    if int(s[0]) == 2:
        if int(s[1]) >= 5:
            s[1] = "5"
            if int(s[2]) > 5:
                s[2] = "5"
                    
    # UPDATE DECIMAL         
    decimal = ThumbWriter("".join(s),52,11,0,0,False)
    # CONVERT TO BINARY
    binary = ThumbWriter(decToByte(int(s[0])*100+int(s[1])*10+int(s[2])),27,0,0,0,False)
    # CONVERT TO HEX
    hexadecimal = ThumbWriter(byteToHex(binary.text),57,22,0,0,False)
    
    
# ADJUSTS A HEX DIGIT UP OR DOWN
def adjustHexDigit():
    
    # GLOBAL OBJECTS WE NEED TO CHANGE?
    global binary
    global decimal
    global hexadecimal
    
    # BEEP!
    thumby.audio.play(4500, 50)
    
    # MAP OUT HEX DIGITS
    h = ["0",   "1",    "2",    "3",    "4",    "5",    "6",    "7",    "8",    "9",    "A",    "B",    "C",    "D",    "E",    "F"]
        
    # ADJUST UP?
    if thumby.buttonU.pressed():
        for i in range(0,16):
            if col == 0:
                if h[i]==hexadecimal.text[0:1]:
                    hexadecimal = ThumbWriter((h[i+1] if i < 15 else "0") + hexadecimal.text[1:2],57,22,0,0,False)
                    break
            else:
                if h[i]==hexadecimal.text[1:2]:
                    hexadecimal = ThumbWriter(hexadecimal.text[0:1] + (h[i+1] if i < 15 else "0"),57,22,0,0,False)
                    break
        
    # ADJUST DOWN?
    elif thumby.buttonD.pressed():
        h = ["0",   "1",    "2",    "3",    "4",    "5",    "6",    "7",    "8",    "9",    "A",    "B",    "C",    "D",    "E",    "F"]
        for i in range(0,16):
            if col == 0:
                if h[i]==hexadecimal.text[0:1]:
                    hexadecimal = ThumbWriter((h[i-1] if i > 0 else "F") + hexadecimal.text[1:2],57,22,0,0,False)
                    break
            else:
                if h[i]==hexadecimal.text[1:2]:
                    hexadecimal = ThumbWriter(hexadecimal.text[0:1] + (h[i-1] if i > 0 else "F"),57,22,0,0,False)
                    break
                
    # CONVERT TO BIN
    binary = ThumbWriter(hexToByte(hexadecimal.text),27,0,0,0,False)
    # CONVERT TO DEC
    decimal = ThumbWriter(byteToDec(binary.text),52,11,0,0,False)
    
    
# THE PROGRAM =====================================================

# LOAD ALL SPRITES
bg = thumby.Sprite(72,40,bytearray([0,0,0,0,0,0,31,31,21,10,0,17,31,31,17,0,31,31,3,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,248,136,112,0,112,248,168,144,0,112,248,136,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,192,0,192,0,128,192,64,128,0,192,192,128,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,7,0,3,7,5,4,0,6,7,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),0,0)
sprAUp = thumby.Sprite(10, 8, bytearray([60,126,195,193,237,195,126,189,66,60]), 61, 32)
sprADown = thumby.Sprite(10, 8, bytearray([0,0,60,126,195,193,237,195,126,60]), 61, 32)
sprBUp = thumby.Sprite(10, 8, bytearray([60,126,193,193,213,235,126,189,66,60]), 1, 32)
sprBDown = thumby.Sprite(10, 8, bytearray([0,0,60,126,193,193,213,235,126,60]), 1, 32)
sprCursor = thumby.Sprite(3,2,bytearray([2,3,2]),27,8)

# KEEP TRACK OF WHICH ACTION BUTTONS ARE DOWN
aDown = False
bDown = False

# TEXT
quit = ThumbWriter("Quit",13,33,0,5,False)
binary = ThumbWriter("00000000",27,0,0,0,False)
decimal = ThumbWriter("000",52,11,0,0,False)
hexadecimal = ThumbWriter("00",57,22,0,0,False)
mode = ThumbWriter("Next",40,33,0,5,False)

# CONTROL BLINKING CURSOR
cursorTimer = 0
showCursor = True

# HANDLE CURSOR POSITIONING
# ACROSS NUMBER SYSTEM ROWS
x = [27,52,57]
y = [6,17,28]
row = 0
col = 0

# APP RUNS AT 30 FPS
thumby.display.setFPS(30)

# SET FALSE TO QUIT
running = True

# MAIN LOOP!!
while running:
    
    # DRAW THE BACKGROUND
    thumby.display.drawSprite(bg)
    
    # HANDLE B-BUTTON PRESSES (QUIT)
    if thumby.buttonB.pressed():
        if not bDown:
            thumby.audio.play(6000, 50)
        bDown = True
    else:
        if bDown:
            thumby.audio.play(8000, 50)
            running = False
        
    # MOVE TO NEXT ROW?
    # HANDLE A-BUTTON PRESSES
    if thumby.buttonA.pressed():
        if not aDown:
            thumby.audio.play(6000, 50)
        aDown = True
    else:
        if aDown:
            row = row + 1 if row < 2 else 0
            col = 0
            cursorTimer = -1
            showCursor = True   
            aDown = False
            thumby.audio.play(8000, 50)

    # ADJUSTING DIGITS UP OR DOWN?
    if thumby.buttonU.justPressed() or thumby.buttonD.justPressed():
        if row == 0:
            adjustBinDigit()
        elif row == 1:
            adjustDecDigit()
        else:
            adjustHexDigit()
        
    # MOVE CURSOR RIGHT
    if thumby.buttonR.justPressed():
        thumby.audio.play(4500, 50)
        if row == 0:
            col = col + 1 if col < 7 else 0
        elif row == 1:
            col = col + 1 if col < 2 else 0
        elif row == 2:
            col = col + 1 if col < 1 else 0
        cursorTimer = -1
        showCursor = True
        
    # MOVE CURSOR LEFT
    if thumby.buttonL.justPressed():
        thumby.audio.play(4500, 50)
        if row == 0:
            col = col - 1 if col > 0 else 7
        elif row == 1:
            col = col - 1 if col > 0 else 2
        elif row == 2:
            col = col - 1 if col > 0 else 1
        cursorTimer = -1
        showCursor = True

    # INCREASE THE BLINKING CURSOR TIMER
    cursorTimer += 1
    
    # TOGGLE CURSOR VISIBILITY?
    if cursorTimer >= 10:
        cursorTimer = 0
        showCursor = not showCursor
    
    # SET CURSOR POSITION
    sprCursor.x = x[row] + col*5
    sprCursor.y = y[row]
    
    # DRAW THE B-BUTTON SPRITES
    thumby.display.drawSprite(sprADown) if thumby.buttonA.pressed() else thumby.display.drawSprite(sprAUp)
    thumby.display.drawSprite(sprBDown) if thumby.buttonB.pressed() else thumby.display.drawSprite(sprBUp)
    
    # DRAW THE CURSOR
    if showCursor: thumby.display.drawSprite(sprCursor)
    
    # DRAW TEXT
    binary.draw()
    decimal.draw()
    hexadecimal.draw()
    quit.draw()
    mode.draw()
    
    # FLIP TO THE SCREEN
    thumby.display.update()
    
# SHHHHH...
thumby.audio.stop()

# ---------------------------------------------- END